const masterData = {
    tools: {
        'jobbanalys': {
            priority: 1,
            title: 'Jobbanalys',
            description: 'Klistra in en annons för att förstå en roll på djupet.',
            completed: false,
            scenarios: ['A'],
            audiences: ['medarbetare', 'chef', 'egen']
        },
        'hitta-karriarvagar': {
            priority: 1,
            title: 'Hitta karriärvägar',
            description: 'Utforska möjliga roller baserat på dina kompetenser.',
            completed: false,
            scenarios: ['A'],
            audiences: ['medarbetare', 'egen']
        },
        'lagg-till-spar': {
            priority: 1,
            title: 'Lägg till spår',
            description: 'Skapa ett nytt spår manuellt för ett jobb eller en idé.',
            completed: false,
            scenarios: ['A'],
            audiences: ['medarbetare', 'chef', 'chef']
        },
        'branschanalys': {
            priority: 2,
            title: 'Branschanalys',
            description: 'Få en överblick över trender i en specifik bransch.',
            completed: false,
            scenarios: ['A', 'B', 'C', 'D'],
            audiences: ['medarbetare', 'chef']
        }
    },
    scenarios: {
        A: { // Ny användare: 0 spår
            insights: [],
            tracks: []
        },
        B: { // Noob: 2 spår
            insights: [{
                id: 1,
                type: 'note',
                category: 'Resultat',
                content: '<p>Löste en bugg...</p>',
                trackId: 1,
                scenarios: ['B'],
                audiences: ['medarbetare', 'chef']
            }],
            tracks: [{
                id: 1,
                name: 'Ansökan till Företag X',
                scenarios: ['B'],
                audiences: ['medarbetare', 'chef']
            }, {
                id: 2,
                name: 'Spontanansökan Y',
                scenarios: ['B'],
                audiences: ['medarbetare', 'chef', 'egen']
            }]
        },
        C: { // Noob+: 4 spår
            insights: [{
                id: 1,
                type: 'note',
                category: 'Resultat',
                content: '<p>Jag ledde mitt team...</p>',
                trackId: 1,
                scenarios: ['C'],
                audiences: ['medarbetare']
            }, {
                id: 2,
                type: 'collection',
                category: 'Metoder',
                items: ['Figma', 'React'],
                trackId: 1,
                scenarios: ['C'],
                audiences: ['medarbetare', 'chef']
            }, {
                id: 3,
                type: 'note',
                category: 'Styrkor',
                content: '<p>Kommunikation...</p>',
                trackId: 2,
                scenarios: ['C'],
                audiences: ['medarbetare', 'chef', 'egen']
            }],
            tracks: [{
                id: 1,
                name: 'Ansökan Exempelföretag',
                scenarios: ['C'],
                audiences: ['medarbetare', 'chef']
            }, {
                id: 2,
                name: 'Jobb på Klarna',
                scenarios: ['C'],
                audiences: ['medarbetare', 'egen']
            }, {
                id: 3,
                name: 'Idé: Starta eget',
                scenarios: ['C'],
                audiences: ['medarbetare', 'chef']
            }, {
                id: 4,
                name: 'chefuppdrag via GoMonday',
                scenarios: ['C'],
                audiences: ['medarbetare', 'chef', 'chef']
            }]
        },
        D: { // 1337-user: 10 spår
            insights: [{
                id: 8,
                type: 'note',
                category: 'Styrkor',
                content: '<p>Kommunikation...</p>',
                trackId: null,
                scenarios: ['D'],
                audiences: ['medarbetare', 'egen']
            }, {
                id: 12,
                type: 'note',
                category: 'Resultat',
                content: '<p>Nordic Marketing Awards...</p>',
                trackId: null,
                scenarios: ['D'],
                audiences: ['medarbetare', 'chef']
            }, {
                id: 1,
                type: 'note',
                category: 'Resultat',
                content: '<p>Omstruktureringar...</p>',
                trackId: 1,
                scenarios: ['D'],
                audiences: ['medarbetare']
            }, {
                id: 4,
                type: 'collection',
                category: 'Verktyg',
                items: ['Figma', 'React', 'Github'],
                trackId: 1,
                scenarios: ['D'],
                audiences: ['medarbetare', 'chef', 'egen']
            }],
            tracks: [{
                id: 1,
                name: 'Ansökan Exempelföretag',
                scenarios: ['D'],
                audiences: ['medarbetare', 'chef']
            }, {
                id: 2,
                name: 'Ansökan Klarna',
                scenarios: ['D'],
                audiences: ['medarbetare', 'egen', 'chef']
            }, {
                id: 3,
                name: 'Ansökan Google',
                scenarios: ['D'],
                audiences: ['medarbetare', 'egen']
            }, {
                id: 4,
                name: 'Spår: Fintech Stockholm',
                scenarios: ['D'],
                audiences: ['medarbetare', 'chef']
            }, {
                id: 5,
                name: 'Spår: Produktägare SaaS',
                scenarios: ['D'],
                audiences: ['medarbetare']
            }, {
                id: 6,
                name: 'chefuppdrag #1',
                scenarios: ['D'],
                audiences: ['medarbetare', 'chef']
            }, {
                id: 7,
                name: 'Nätverkskontakt via Lisa',
                scenarios: ['D'],
                audiences: ['medarbetare', 'chef']
            }, {
                id: 8,
                name: 'Idé: Söka jobb i Berlin',
                scenarios: ['D'],
                audiences: ['medarbetare', 'egen', 'chef']
            }, {
                id: 9,
                name: 'Spontanansökan Acme Inc.',
                scenarios: ['D'],
                audiences: ['medarbetare', 'chef']
            }, {
                id: 10,
                name: 'Drömjobbet på Spotify',
                scenarios: ['D'],
                audiences: ['medarbetare', 'egen']
            }]
        }
    }
};