// data.js
// All data är nu inslagen i en JavaScript-variabel istället för att vara en ren JSON.
// Denna variabel blir globalt tillgänglig när filen laddas.
const masterData = {
  "tools": {
    "energi": {
      "priority": 1, "title": "Vad ger dig energi?", "description": "Definiera vad du vill göra mer eller mindre av.", "completed": false,
      "scenarios": ["A", "B", "C", "D"], "audiences": ["medarbetare", "chef", "egen"]
    },
    "varderingar": {
      "priority": 1, "title": "Definiera dina värderingar", "description": "Sätt ord på vad som är viktigast för dig.", "completed": false,
      "scenarios": ["A", "B", "C", "D"], "audiences": ["medarbetare", "chef"]
    },
    "styrkor": {
      "priority": 1, "title": "Hitta dina styrkor", "description": "Identifiera och formulera dina främsta styrkor.", "completed": false,
      "scenarios": ["A", "B", "C", "D"], "audiences": ["medarbetare", "chef"]
    },
    "drivkrafter": {
      "priority": 2, "title": "Hitta dina drivkrafter", "description": "Förstå vad som motiverar dig på djupet.", "completed": false,
      "scenarios": ["B", "C", "D"], "audiences": ["medarbetare", "chef"]
    },
    "resultat": {
      "priority": 2, "title": "Beskriv dina resultat", "description": "Formulera konkreta exempel på vad du åstadkommit.", "completed": false,
      "scenarios": ["B", "C", "D"], "audiences": ["medarbetare", "chef", "egen"]
    },
    "chef": {
      "priority": 3, "title": "Så ska chefen vara", "description": "Reflektera över vilket ledarskap du trivs med.", "completed": false,
      "scenarios": ["C", "D"], "audiences": ["medarbetare", "chef"]
    },
    "pengar": {
      "priority": 3, "title": "Om pengar inte var ett problem", "description": "En kreativ övning för att hitta dina drivkrafter.", "completed": false,
      "scenarios": ["C", "D"], "audiences": ["medarbetare"]
    }
  },
  "insights": [
    { "id": 1, "type": "note", "category": "Resultat", "content": "<p>Jag ledde mitt team genom omstruktureringar efter uppköpet av Absolut Vodka, vilket resulterade i att samtliga teammedlemmar fick kvalificerade positioner i den nya organisationen.</p>", "trackId": 1, "pinned": false, "scenarios": ["D"], "audiences": ["chef"] },
    { "id": 2, "type": "note", "category": "Värderingar", "content": "<p><strong>Hjälpsamhet.</strong> Jag tycker att man alltid ska stötta varandra aktivt, dela med sig av kunskap och bidra till en bra miljö där det är naturligt att be om och erbjuda hjälp.</p>", "trackId": 3, "pinned": false, "scenarios": ["B", "C", "D"], "audiences": ["medarbetare", "chef"] },
    { "id": 3, "type": "note", "category": "Testimonials", "content": "<blockquote>\"Personen är en av de mest drivna och strategiska marknadsförare jag arbetat med. Alltid med ett öga på resultatet och med en fantastisk förmåga att få med sig teamet.\"</blockquote>", "trackId": 1, "pinned": true, "scenarios": ["B", "C", "D"], "audiences": ["chef", "egen"] },
    { "id": 7, "type": "note", "category": "Analys", "content": "<p>De söker en frontend-utvecklare med 3+ års erfarenhet av React och TypeScript. De betonar teamarbete och agila metoder, vilket passar mig bra.</p>", "trackId": 1, "pinned": false, "scenarios": ["C", "D"], "audiences": ["medarbetare"] },
    { "id": 8, "type": "note", "category": "Styrkor", "content": "<p><strong>Kommunikation:</strong> Är bra på att förklara komplexa tekniska koncept för icke-tekniska personer.</p><p><strong>Problemlösning:</strong> Älskar att gräva ner mig i svåra buggar.</p>", "trackId": 3, "pinned": true, "scenarios": ["C", "D"], "audiences": ["medarbetare", "egen"] },
    { "id": 9, "type": "note", "category": "Research", "content": "<p>Klarna verkar satsa stort på AI för att personalisera köpupplevelsen. Intressant att nämna i en ansökan.</p>", "trackId": 2, "pinned": false, "scenarios": ["C", "D"], "audiences": ["medarbetare"] },
    { "id": 10, "type": "note", "category": "Intressen", "content": "<p>Jag drivs av att bygga produkter som förenklar vardagen för användaren. Gillar också att jobba datadrivet.</p>", "trackId": 3, "pinned": false, "scenarios": ["C", "D"], "audiences": ["medarbetare", "chef", "egen"] },
    { "id": 11, "type": "note", "category": "Lärdomar & Insikter", "content": "<p>Fått upp ögonen för hur kombinationer av kommunikativa insatser kan stärka målgruppens intresse och engagemang på djupet.</p>", "trackId": null, "pinned": false, "scenarios": ["D"], "audiences": ["chef", "egen"] },
    { "id": 12, "type": "note", "category": "Resultat", "content": "<p>Jag och mitt team erhöll <strong>Nordic Marketing Excellence Awards</strong> i samtliga tävlande kategorier två år i rad.</p>", "trackId": null, "pinned": false, "scenarios": ["D"], "audiences": ["chef"] },
    { "id": 13, "type": "note", "category": "Optimala förutsättningar", "content": "<p>Trivs bäst i tvärfunktionella team där det är högt i tak och man vågar testa nya idéer. Gillar en blandning av fokuserat eget arbete och kreativa workshops.</p>", "trackId": 3, "pinned": false, "scenarios": ["D"], "audiences": ["medarbetare", "chef"] },
    { "id": 14, "type": "note", "category": "Värderingar", "content": "<p><strong>Ömsesidig tillit</strong> innebär för mig att vi har en positiv grundsyn på varandras förmågor och vilja att göra något bra. Att vi ger varandra friheten att utvecklas.</p>", "trackId": null, "pinned": false, "scenarios": ["D"], "audiences": ["medarbetare", "chef", "egen"] },
    { "id": 4, "type": "collection", "category": "Metoder & Verktyg", "items": ["Figma", "React", "Github", "Lean", "Agile Development", "Wordpress", "Six Sigma", "Jira", "Docker", "Kubernetes", "MIG-svetsning"], "trackId": 1, "pinned": false, "scenarios": ["D"], "audiences": ["medarbetare", "egen"] },
    { "id": 5, "type": "collection", "category": "Certifikat & Bevis", "items": ["B-körkort", "Truck-kort A+B", "MBA", "ICC-certifierad coach", "Finanskompetens ÅKU 2024"], "trackId": null, "pinned": false, "scenarios": ["D"], "audiences": ["chef", "egen"] },
    { "id": 6, "type": "collection", "category": "Språk", "items": ["Svenska (modersmål)", "Engelska (flytande)", "Tyska (grundläggande)"], "trackId": 3, "pinned": false, "scenarios": ["D"], "audiences": ["medarbetare", "chef", "egen"] }
  ]
};