// =================================================================
//  SERVICES CONFIGURATION (Single Source of Truth)
// =================================================================
// This file contains all definitions for services and their
// corresponding booking flows. It's the single source of truth for
// both the triage and booking applications.
// =================================================================

// The default booking flow to use if no specific one is provided.
const BOOKING_FLOW_DEFAULT_ID = '1';

// Defines the actual steps and UI for each booking process.
const BOOKING_FLOWS = {
    '1': {
        title: 'Samtal med jobbexpert',
        primaryCTA: {
            type: 'booking',
            buttonText: 'Välj tid',
            confirmationTitle: '✔️ Klart, du har bokat!',
            confirmationBody: 'En bekräftelse har skickats till din e-post. Du kan lägga till mer information när som helst via ditt konto.'
        },
        steps: [
            {
                type: 'questions',
                id: 'step1_situation',
                questions: [
                    { id: 'a1', type: 'textarea', label: 'Hur ser ditt jobbliv ut idag, kortfattat?', placeholder: 'Skriv ditt svar här...' },
                    { id: 'a2', type: 'textarea', label: 'Hur vill du att det ser ut?', placeholder: 'Skriv ditt svar här...' }
                ],
                action: {
                    type: 'ai_loop',
                    sendToAI: ['a1', 'a2'],
                    maxFollowUps: 3,
                    aiCriteriaPrompt: `Mål: Få en bild av nuläge och önskat läge. Push-faktorer (vad skaver nu?). Pull-faktorer (vad lockar i framtiden?). Gärna någon tanke om roll/bransch, men pressa inte om personen inte vet.`
                }
            },
            {
                type: 'questions',
                id: 'step2_problem',
                questions: [
                    { id: 'a3', type: 'textarea', label: 'Var klämmer skon?', placeholder: 'Vad har du för fråga till jobbexperten som du vill få svar på i samtalet?' },
                    { id: 'a4', type: 'textarea', label: 'Vad vill du ha ut av samtalet?', placeholder: 'En metod som jag kan använda framöver / Konkreta tips / Ett exakt svar på frågan / Prata av mig / Nya infallsvinklar att ta med mig / Annat...' }
                ],
                action: {
                    type: 'ai_loop',
                    sendToAI: ['a3', 'a4'],
                    maxFollowUps: 3,
                    aiCriteriaPrompt: `Mål: Förstå användarens kärnproblem och vad de hoppas uppnå med samtalet. Klargör eventuella oklarheter i deras fråga eller önskade resultat. Se till att coachen kommer väl förberedd.`
                }
            }
        ]
    },
    '2': {
        title: 'Samtal om nytt karriärval',
        primaryCTA: {
            type: 'booking',
            buttonText: 'Välj tid',
            confirmationTitle: '✔️ Klart, du har bokat!',
            confirmationBody: 'En bekräftelse har skickats till din e-post. Du kan lägga till mer information när som helst via ditt konto.'
        },
        steps: [
            {
                type: 'questions',
                id: 'step1_target',
                questions: [
                    { id: 's2_q1', type: 'textarea', label: 'Berätta lite kort vad du söker dig till', placeholder: 'Arbetsgivare, bransch, tjänst...' },
                    { id: 's2_q2', type: 'textarea', label: 'Är det något särskilt du ser som utmanande?', placeholder: 'Något du själv tänkt på, som du inte är nöjd med eller som du inte vet hur du ska lösa...?' }
                ],
                action: {
                    type: 'ai_loop',
                    sendToAI: ['s2_q1', 's2_q2'],
                    maxFollowUps: 2,
                    aiCriteriaPrompt: `Mål: Få en bild av nuläge och önskat läge. Push-faktorer (vad skaver nu?). Pull-faktorer (vad lockar i framtiden?). Gärna någon tanke om roll/bransch, men pressa inte om personen inte vet.`
                }
            },
            {
                type: 'questions',
                id: 'step2_details',
                questions: [
                    { id: 's2_q3', type: 'textarea', label: 'Är det någon annan information som kan vara användbar för oss?', placeholder: 'Du kanske haft kontakt med arbetsgivaren tidigare, eller känner något utöver det som sägs i annonsen?' },
                    { id: 's2_q4', type: 'textarea', label: 'Vad får vi inte glömma att bemöta när du får din feedback?', placeholder: 'Vad känns allra viktigast för dig?' }
                ],
                action: {
                    type: 'ai_loop',
                    sendToAI: ['s2_q3', 's2_q4'],
                    maxFollowUps: 1,
                    aiCriteriaPrompt: `Mål: Förstå användarens kärnproblem och vad de hoppas uppnå med samtalet. Klargör eventuella oklarheter i deras fråga eller önskade resultat. Se till att coachen kommer väl förberedd.`
                }
            }
        ]
    },
    '3': {
        title: 'Granskning av ansökan',
        primaryCTA: {
            type: 'submit',
            buttonText: 'Slutför & skicka in',
            confirmationTitle: '✔️ Tack, vi har tagit emot dina filer!',
            confirmationBody: 'En expert kommer att granska ditt underlag och återkomma till dig via mail inom 2-3 arbetsdagar.'
        },
        steps: [
            {
                type: 'questions',
                id: 'step1_ad_context',
                questions: [
                    { id: 'q1_interest', type: 'textarea', label: 'Berätta lite kort vad du söker dig till', placeholder: 'Arbetsgivare, bransch, tjänst...' },
                    { id: 'q2_ad_file', type: 'file', label: 'Bifoga en platsannons' }
                ],
                action: {
                    type: 'next_step'
                }
            },
            {
                type: 'questions',
                id: 'step2_cv_upload',
                questions: [
                    { id: 'q3_cv_file', type: 'file', label: 'Ladda upp ditt CV' }
                ],
                action: {
                    type: 'next_step'
                }
            }
        ]
    }
};

// Defines the services presented in the triage step.
// Each service maps to a specific booking flow via `bookingFlowId`.
const SERVICES = {
  'written_feedback': {
    name: 'Skriftlig feedback på jobbansökan',
    description: 'Få skriftlig feedback på ditt CV och personliga brev av en jobbexpert. Vi går igenom dina dokument och återkopplar inom 24 timmar. Du kan till exempel få veta om något är otydligt, om det finns något du ska ta bort, eller trycka mer på. Dessutom får du ett omdöme på en skala 1-100 hur stark din ansökan är.',
    meta: {
      expert_pool_id: 'junior_expert',
      target_keywords: ['cv', 'personligt brev', 'ansökan', 'granskning', 'feedback', 'omdöme'],
      use_case: 'Bäst för att få en övergripande bedömning av ansökningshandlingar – struktur, språk, tydlighet, första intryck. Ger tips och råd om vad som kan förbättras.',
      avoid_for: 'Mindre lämplig för att lösa specifika, personliga dilemman (t.ex. "hur förklarar jag en lucka i CV:t?"), då dessa frågor oftast kräver en dialog och ett samtal är bättre.',
      format: 'skriftlig',
      threshold: 'låg',
      business_priority: 'hög'
    },
    bookingFlowId: '3'
  },
  'samtal_ansokan_presentation': {
    name: 'Samtal: Ansökan & Presentation',
    description: 'För dig som behöver hjälp med CV, intervju, Linkedin och att presentera dig själv.',
    meta: {
      expert_pool_id: 'presentation_expert',
      target_keywords: ['cv', 'intervju', 'linkedin', 'ansökningar', 'spretigt'],
      use_case: 'Bäst för att föra ett resonemang kring en ansökan eller presentation, hitta en story, formulera budskap, lösa problem.',
      avoid_for: 'Allmän genomgång av handlingar, bedömning',
      format: 'samtal',
      threshold: 'hög',
      business_priority: 'medel'
    },
    bookingFlowId: '1'
  },
  'samtal_riktning': {
    name: 'Samtal: Riktning & strategi',
    description: 'För dig som är vilsen, vill byta bransch, skapa en strategi eller planera långsiktigt.',
    meta: {
      expert_pool_id: 'senior_expert',
      target_keywords: ['strategi', 'plan', 'karriärväg', 'byta bransch', 'komma framåt', 'stökigt'],
      use_case: '',
      avoid_for: '',
      format: 'samtal',
      threshold: 'hög',
      priority: 'hög',
      business_priority: 'medel'
    },
    bookingFlowId: '2'
  },
  'samtal_lon_anstallning': {
    name: 'Samtal: Lön & anställning',
    description: 'För dig som ska löneförhandla, har frågor om kontrakt eller andra anställningsvillkor.',
    meta: {
      expert_pool_id: 'senior_expert',
      target_keywords: ['lön', 'lönesamtal', 'förhandla', 'kontrakt', 'avtal', 'anställning'],
      use_case: '',
      avoid_for: '',
      format: 'samtal',
      threshold: 'hög',
      business_priority: 'låg'
    },
    bookingFlowId: '1'
  },
  'intervjutraning': {
    name: 'Intervjuträning',
    description: 'För dig som behöver förbereda dig och träna inför en intervju. ',
    meta: {
      expert_pool_id: 'interview_expert',
      target_keywords: ['intervju', 'förbereda'],
      use_case: '',
      avoid_for: '',
      format: 'samtal',
      threshold: 'hög',
      business_priority: 'låg'
    },
    bookingFlowId: '1'
  }
};
